<?php
/**
 * Tags
 *
 * @package     AutomatorWP\OpenAI\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Friendship tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_openai_get_actions_response_tags() {

    return array(
        'response' => array(
            'label'     => __( 'OpenAI response', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'OpenAI response',
        ),
    );

}

/**
 * Custom action response tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $action         The action object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last action log object
 *
 * @return string
 */
function automatorwp_openai_get_action_response_tag_replacement( $replacement, $tag_name, $action, $user_id, $content, $log ) {


    $action_args = automatorwp_get_action( $action->type );

    // Skip if action is not from this integration
    if( $action_args['integration'] !== 'openai' ) {
        return $replacement;
    }

    switch( $tag_name ) {
        case 'response':
            $replacement = automatorwp_get_log_meta( $log->id, 'response', true );
            break;
    }

    return $replacement;

}
add_filter( 'automatorwp_get_action_tag_replacement', 'automatorwp_openai_get_action_response_tag_replacement', 10, 6 );